CREATE PROCEDURE [dbo].[PMX_SP_GoodsReceiptLabel_Mass] 
	-- Parameters for the stored procedure
	@count int

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

declare @list table
(
	sscc nvarchar (18),
	gtin nvarchar (16),
	ProductDescription nvarchar(100),
	quantity numeric (19,6),
	batchNumber nvarchar (32),
	bestBeforeDate nvarchar(50),
	SSCCBarcode nvarchar (100),
	SSCCBarcodeDigit nvarchar (100),
	GTINBarcode nvarchar (200),
	GTINBarcodeDigit nvarchar (200),
	purchaseDocObjType nvarchar(20),
	purchaseDocNum nvarchar(50),
	supplierName nvarchar (100),
	supplierAddress nvarchar (254),
	receptionDate nvarchar(50),
	GTINLabel nvarchar (20),
	PackagingTypeText nvarchar (max),
	QuantityByPackagingTypeText nvarchar (max),
	BatchNumber2 nvarchar(32) ,
	LocationCode nvarchar(50) ,
	itemCode nvarchar (20)
);

	declare @currentSSCCInt as bigint;


/**************************************************/
/* MODIFY PARAMETERS BELOW ************************/
/**************************************************/

	set @currentSSCCInt = 00000000000000001;

/**************************************************/
/* DO NOT MODIFY CODE BELOW ***********************/
/**************************************************/

declare @i int = 0;

	declare @luid int = 0;
	declare @sscc nvarchar (18) = '';
	declare @itemCode nvarchar (20) = null;
	declare @quantity numeric (19,6) = 0;
	declare @bestBeforeDate datetime = null;
	declare @batchNumber nvarchar (32) = null;
	declare @purchaseDocObjType nvarchar(20) = null;
	declare @purchaseDocEntry int = null;
	declare @cardCode nvarchar (15) = null;
	declare @packagingTypeText nvarchar(max) = null;
	declare @quantityByPackagingTypeText nvarchar(max) = null;
	declare @locationCode nvarchar (50) = null;
	declare @batchNumber2 nvarchar (32) = null;
	declare @quantityUom2 numeric (19,6) = null;
	declare @internalLuid int = 0;

	--Declare return variables
	DECLARE @returnSSCC [nvarchar](18)
	DECLARE @returnGTIN AS [nvarchar] (16) 
	DECLARE @returnLogisticCarrierCode AS [nvarchar] (20)  
	DECLARE @returnItemCode AS [nvarchar](20) 
	DECLARE @returnProductDescription AS [nvarchar](100) 
	DECLARE @returnQuantity AS [numeric](19,6) 
	DECLARE @returnIsLogisticUnit AS [nvarchar](1) 
	DECLARE @returnBatchNumber AS [nvarchar](32) 
	DECLARE @returnBestBeforeDate AS [datetime]
	DECLARE @returnSSCCBarcode AS [nvarchar] (100)
	DECLARE @returnSSCCBarcodeDigit AS [nvarchar] (100)
	DECLARE @returnGTINBarcode AS [nvarchar] (200)
	DECLARE @returnGTINBarcodeDigit AS [nvarchar] (200)
 	DECLARE @returnBarcodeType AS [nvarchar] (1)
	DECLARE @returnGTINLabel AS [nvarchar] (20)
	DECLARE @returnPackagingTypeText AS [nvarchar] (max)
	DECLARE @returnQuantityByPackagingTypeText AS [nvarchar] (max)
	DECLARE @returnBatchNumber2 AS [nvarchar](32) 
	DECLARE @returnLocationCode AS [nvarchar](50) 


	--Getting the PO info
	--Declare variables for the cursor
	DECLARE @PurchaseDocNum AS [int]
	DECLARE @SupplierName AS [nvarchar] (100) 
	DECLARE @SupplierAddress AS [nvarchar] (254)  
	DECLARE @ReceptionDate AS [datetime] 


	--Declare variables for product
	DECLARE @GTIN AS [nvarchar] (16) 
	DECLARE @LogisticCarrierCode AS [nvarchar] (20)  
	DECLARE @ProductDescription AS [nvarchar](100) 
	DECLARE @IsLogisticCarrier AS [nvarchar](1) 
	DECLARE @BarcodeType AS [nvarchar] (1)
	DECLARE @TempPackagingTypeText AS [nvarchar] (max)
	DECLARE @TempQuantityByPackagingTypeText AS [nvarchar] (max)


	DECLARE @weightDecimals AS INT
	DECLARE @weightAI AS [nvarchar](3) 
	DECLARE @tempWeightDecimals AS INT
	DECLARE @tempWeightAI AS [nvarchar](3) 
	DECLARE @tempQuantityUom2 AS [numeric](19,6) 
	
	set @i = 0;
	while @i < @count
	BEGIN
	
		select @sscc = dbo.PMX_FN_GenerateSSCC(CAST(@currentSSCCInt as nvarchar(20)));
		set @currentSSCCInt = @currentSSCCInt + 1;
	
		SET @returnSSCC = @SSCC
		SET @returnItemCode = @ItemCode
		SET @returnQuantity = @Quantity
		SET @returnBatchNumber = @BatchNumber
		SET @returnBestBeforeDate = @BestBeforeDate
		SET @returnPackagingTypeText = @PackagingTypeText
		SET @returnQuantityByPackagingTypeText = @quantityByPackagingTypeText
		SET @returnBatchNumber2 = @BatchNumber2
		SET @returnLocationCode = @LocationCode

		SET @ReceptionDate = Getdate()

		--Purchase info
		IF @purchaseDocObjType = '22'
		BEGIN
		    SELECT TOP 1    @PurchaseDocNum = DocNum,
                            @SupplierName = CardName,
                            @SupplierAddress = [Address]
		    FROM dbo.OPOR
		    WHERE DocEntry = @purchaseDocEntry
		    ORDER BY DocNum DESC
		END
		ELSE IF @purchaseDocObjType = '18'
		BEGIN
		    SELECT TOP 1    @PurchaseDocNum = DocNum,
                            @SupplierName = CardName,
                            @SupplierAddress = [Address]
		    FROM dbo.OPCH
		    WHERE DocEntry = @purchaseDocEntry
		    ORDER BY DocNum DESC
		END
		ELSE BEGIN
			SELECT TOP 1	@SupplierName = CardName
			FROM OCRD
			WHERE OCRD.CardCode = @cardCode
		END

		SELECT @returnIsLogisticUnit = OITM.U_PMX_LOUN, @returnBarcodeType = ISNULL(U_PMX_BCTY,'G'), 
		@returnGTIN = CodeBars, @returnProductDescription = ItemName,
		@weightDecimals = U_PMX_UM2D, 
		@weightAI = U_PMX_U2MT+'0'
		FROM OITM WHERE OITM.ItemCode = @itemCode

		IF(@returnIsLogisticUnit = 'Y') SET @returnGTINLabel = 'GTIN'
		ELSE SET @returnGTINLabel = 'CONTENT'

		--Set the barcodes
		SET @returnSSCCBarcode = dbo.PMX_FN_GenerateGS1Barcode( @returnSSCC, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'' )
		SET @returnSSCCBarcodeDigit = dbo.PMX_FN_GenerateGS1BarcodeDigit ( @returnSSCC, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL )
		SET @returnGTINBarcode = dbo.PMX_FN_GenerateGS1Barcode( NULL, @returnGTIN, @returnIsLogisticUnit, @returnBarcodeType,  @returnBestBeforeDate, @returnBatchNumber, @returnQuantity, @quantityUom2, @weightDecimals, @weightAI, '')
		SET @returnGTINBarcodeDigit = dbo.PMX_FN_GenerateGS1BarcodeDigit ( NULL , @returnGTIN, @returnIsLogisticUnit, @returnBarcodeType,  @returnBestBeforeDate, @returnBatchNumber, @returnQuantity, @quantityUom2, @weightDecimals, @weightAI)


	--Return the values
	--SELECT
	insert into @list values (
			@returnSSCC, 	
			ISNULL(@returnGTIN,'N/A'),
			ISNULL(@returnProductDescription,'N/A'), 
			ISNULL(CAST (CAST(@returnQuantity AS float) AS nvarchar),'N/A'),
			ISNULL(@returnBatchNumber,'N/A'), 
			ISNULL( CONVERT(nvarchar, @returnBestBeforeDate, 103),'N/A') ,
			@returnSSCCBarcode,
			@returnSSCCBarcodeDigit,
			@returnGTINBarcode,
			@returnGTINBarcodeDigit,
			@PurchaseDocObjType,
			ISNULL( CAST( @PurchaseDocNum AS nvarchar),'N/A'),
			ISNULL(@SupplierName,'N/A'),
			ISNULL(@SupplierAddress,'N/A'),
			ISNULL( CONVERT(nvarchar, @ReceptionDate, 103),'N/A'),
			@returnGTINLabel,
			@returnPackagingTypeText,
			@returnQuantityByPackagingTypeText,
			@returnBatchNumber2, 
			@returnLocationCode,
			@itemCode)

		set @i = @i + 1;
	END
select * from @list
	
END

